/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103;

import org.crusty.g2103.Maze;
import org.crusty.g2103.towers.Tower;
import org.crusty.math.Vec2int;

public class Cell {
    Tower tower = null;
    protected boolean visited = false;
    public Vec2int pos;
    protected Cell[] neighbours = new Cell[4];
    public Cell[] linkedNeighbours = new Cell[4];

    public Cell(int x, int y) {
        int i = 0;
        while (i < 4) {
            this.neighbours[i] = null;
            this.linkedNeighbours[i] = null;
            ++i;
        }
        this.pos = new Vec2int(x, y);
    }

    public void setVisited() {
        this.visited = true;
    }

    public boolean getVisited() {
        return this.visited;
    }

    private boolean canPlaceTower() {
        if (this.tower != null) {
            return false;
        }
        int num = 0;
        int i = 0;
        while (i < 4) {
            if (this.linkedNeighbours[i] == null) {
                ++num;
            }
            ++i;
        }
        return num == 4;
    }

    public boolean placeTower(Tower t) {
        if (this.canPlaceTower()) {
            this.tower = t;
            this.tower.setCellPos(this);
            return true;
        }
        return false;
    }

    public void setCellNeighbour(int num, Cell c) {
        this.neighbours[num] = c;
        c.neighbours[Maze.getOpposite((int)num)] = this;
    }

    public void setLinkedNeighbour(int num, Cell c) {
        this.linkedNeighbours[num] = c;
        c.linkedNeighbours[Maze.getOpposite((int)num)] = this;
    }

    public boolean hasNextSinglePath(Cell prevCell) {
        int walls = 0;
        int i = 0;
        while (i < 4) {
            if (this.linkedNeighbours[i] == null || this.linkedNeighbours[i] == prevCell) {
                ++walls;
            }
            ++i;
        }
        return walls == 3;
    }

    public Cell getNextSinglePath(Cell prevCell) {
        int i = 0;
        Cell c = null;
        while (c == null || c == prevCell) {
            c = this.linkedNeighbours[i];
            ++i;
        }
        return c;
    }
}

