/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.crusty.engine.RootEntity;
import org.crusty.g2103.Cell;
import org.crusty.math.Vec2int;

public class Maze
extends RootEntity {
    public int startx;
    public int starty;
    public int boxWidth;
    public int boxHeight;
    protected int width;
    protected int height;
    Random r;
    protected Cell mazeStart;
    protected Cell[][] cells;

    public Maze(int width, int height) {
        this.width = width;
        this.height = height;
        this.r = new Random();
        long seed = this.r.nextLong();
        System.out.println("Seed: " + seed);
        this.r.setSeed(seed);
        this.startx = 50;
        this.starty = 50;
        this.boxWidth = 20;
        this.boxHeight = 20;
        this.mazeStart = this.generateMaze();
        this.genPath(this.cells);
    }

    public void genPath(Cell[][] cells) {
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                if (!(x == 0 && y == 0 || x == this.width - 1 && y == this.height - 1)) {
                    Cell[] linked = cells[x][y].linkedNeighbours;
                    int num = 0;
                    int i = 0;
                    while (i < 4) {
                        if (linked[i] == null) {
                            ++num;
                        }
                        ++i;
                    }
                    if (num == 3) {
                        this.recursiveFill(cells[x][y]);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public void recursiveFill(Cell c) {
        if (c.pos.x == 0 && c.pos.y == 0 || c.pos.x == this.width - 1 && c.pos.y == this.height - 1) {
            return;
        }
        Cell[] linked = c.linkedNeighbours;
        int num = 0;
        int i = 0;
        while (i < 4) {
            if (linked[i] == null) {
                ++num;
            }
            ++i;
        }
        if (num == 4) {
            System.out.println("ZERO");
        }
        if (num == 3) {
            Cell next = linked[0];
            int dir = 0;
            if (next == null) {
                next = linked[1];
                dir = 1;
            }
            if (next == null) {
                next = linked[2];
                dir = 2;
            }
            if (next == null) {
                next = linked[3];
                dir = 3;
            }
            int opp = Maze.getOpposite(dir);
            c.linkedNeighbours[dir] = null;
            next.linkedNeighbours[opp] = null;
            this.recursiveFill(next);
        }
    }

    public static int getOpposite(int s) {
        if (s > 3) {
            System.out.println("getOpposite too large");
        }
        switch (s) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public int[] randomOrdering(int size) {
        int[] nums = new int[size];
        int i = 0;
        while (i < size) {
            nums[i] = i;
            ++i;
        }
        i = 0;
        while (i < 4) {
            int firstNum = this.r.nextInt(size);
            int secondNum = this.r.nextInt(size);
            int temp = nums[firstNum];
            nums[firstNum] = nums[secondNum];
            nums[secondNum] = temp;
            ++i;
        }
        return nums;
    }

    public void recursiveMazeGeneration(Cell curCell) {
        curCell.setVisited();
        Cell[] curNeighbours = curCell.neighbours;
        int[] randomNums = this.randomOrdering(4);
        int i = 0;
        while (i < 4) {
            Cell c = curNeighbours[randomNums[i]];
            if (c != null && !c.getVisited()) {
                curCell.setLinkedNeighbour(randomNums[i], c);
                this.recursiveMazeGeneration(c);
            }
            ++i;
        }
    }

    public Cell[][] getCells() {
        return this.cells;
    }

    public Cell generateMaze() {
        Cell exit = this.setupBlankMaze();
        this.recursiveMazeGeneration(exit);
        return exit;
    }

    public Cell setupBlankMaze() {
        int x;
        this.cells = new Cell[this.width][this.height];
        int y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width) {
                this.cells[x][y] = new Cell(x, y);
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.height) {
            x = 0;
            while (x < this.width - 1) {
                this.cells[x][y].setCellNeighbour(3, this.cells[x + 1][y]);
                ++x;
            }
            ++y;
        }
        int x2 = 0;
        while (x2 < this.width) {
            int y2 = 0;
            while (y2 < this.height - 1) {
                this.cells[x2][y2].setCellNeighbour(1, this.cells[x2][y2 + 1]);
                ++y2;
            }
            ++x2;
        }
        return this.cells[0][0];
    }

    public Vec2int gridCoordsToPos(Vec2int coords) {
        return new Vec2int(this.startx + coords.x * this.boxWidth + this.boxWidth / 2, this.starty + coords.y * this.boxHeight + this.boxHeight / 2);
    }

    public Vec2int posToGridCoords(Vec2int coords) {
        int x = (-this.startx + (coords.x + this.boxWidth / 2) - this.boxWidth / 2) / this.boxWidth;
        int y = (-this.starty + (coords.y + this.boxWidth / 2) - this.boxHeight / 2) / this.boxHeight;
        x = Math.min(x, this.width - 1);
        x = Math.max(x, 0);
        y = Math.min(y, this.height - 1);
        y = Math.max(y, 0);
        return new Vec2int(x, y);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.YELLOW);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                Cell curCell = this.cells[x][y];
                int xBox = this.startx + x * this.boxWidth + this.boxWidth / 2;
                int yBox = this.starty + y * this.boxHeight + this.boxHeight / 2;
                Cell[] linked = curCell.linkedNeighbours;
                if (linked[0] == null && linked[1] == null && linked[2] == null && linked[3] == null) {
                    g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                } else {
                    g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                }
                if (linked[0] == null) {
                    g.drawLine(xBox - this.boxWidth / 2, yBox - this.boxHeight / 2, xBox + this.boxWidth / 2, yBox - this.boxHeight / 2);
                }
                if (linked[1] == null) {
                    g.drawLine(xBox - this.boxWidth / 2, yBox + this.boxHeight / 2, xBox + this.boxWidth / 2, yBox + this.boxHeight / 2);
                }
                if (linked[2] == null) {
                    g.drawLine(xBox - this.boxWidth / 2, yBox - this.boxHeight / 2, xBox - this.boxWidth / 2, yBox + this.boxHeight / 2);
                }
                if (linked[3] == null) {
                    g.drawLine(xBox + this.boxWidth / 2, yBox - this.boxHeight / 2, xBox + this.boxWidth / 2, yBox + this.boxHeight / 2);
                }
                ++x;
            }
            ++y;
        }
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

