/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.crusty.engine.RootEntity;
import org.crusty.engine.Screen;
import org.crusty.g2103.enemies.Enemy;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.g2103.towers.Tower;
import org.crusty.math.Vec2;

public class Slug
extends RootEntity {
    Enemy e;
    Screen screen;
    int damage;
    float speed;
    Tower tower;

    public Slug(Tower tower, Screen screen, Vec2 pos, Enemy e, int damage, float speed) {
        this.damage = damage;
        this.screen = screen;
        this.pos.x = pos.x;
        this.pos.y = pos.y;
        this.e = e;
        this.speed = speed;
        this.tower = tower;
    }

    @Override
    public void draw(Graphics2D g) {
        Vec2 len = new Vec2(this.vel.x, this.vel.y);
        if (len.x == 0.0 && len.y == 0.0) {
            len.x = 1.0;
        }
        len = len.normalise();
        len.x *= 5.0;
        len.y *= 5.0;
        g.drawLine((int)this.pos.x, (int)this.pos.y, (int)(this.pos.x - len.x), (int)(this.pos.y - len.y));
    }

    @Override
    public void logic(long dt) {
        if (this.screen instanceof LevelMaze) {
            if (this.e == null) {
                ((LevelMaze)this.screen).notifyRemoval(this);
            }
            Vec2 vec = new Vec2(this.e.pos.x - this.pos.x, this.e.pos.y - this.pos.y);
            Vec2 newVel = vec.normalise();
            this.vel.x = newVel.x * (double)this.speed;
            this.vel.y = newVel.y * (double)this.speed;
            super.logic(dt);
            if (vec.length() < (double)(1.0f / (this.speed * 2.0f))) {
                ((LevelMaze)this.screen).notifyRemoval(this);
                if (this.e.doDamage(this.damage)) {
                    this.tower.incKilled();
                }
                this.tower.incDamageDone(this.damage);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

