/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sound {
    public static Clips endGame = Sound.load("endGame.wav", 1);
    public static Clips death = Sound.load("death.wav", 1);
    public static Clips t0 = Sound.load("toneset/0.wav", 1);
    public static Clips t1 = Sound.load("toneset/1.wav", 1);
    public static Clips t2 = Sound.load("toneset/2.wav", 1);
    public static Clips t3 = Sound.load("toneset/3.wav", 1);
    public static Clips t4 = Sound.load("toneset/4.wav", 1);
    public static Clips t5 = Sound.load("toneset/5.wav", 1);
    public static Clips t6 = Sound.load("toneset/6.wav", 1);
    public static Clips t7 = Sound.load("toneset/7.wav", 1);
    public static Clips t8 = Sound.load("toneset/8.wav", 1);
    public static Clips t9 = Sound.load("toneset/9.wav", 1);
    public static Clips t10 = Sound.load("toneset/10.wav", 1);
    public static Clips t11 = Sound.load("toneset/11.wav", 1);
    public static Clips t12 = Sound.load("toneset/12.wav", 1);
    public static Clips t13 = Sound.load("toneset/13.wav", 1);

    private static Clips load(String name, int count) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(ClassLoader.getSystemResourceAsStream(name));
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = dis.read(buffer)) >= 0) {
                baos.write(buffer, 0, read);
            }
            dis.close();
            byte[] data = baos.toByteArray();
            return new Clips(data, count);
        }
        catch (Exception e) {
            try {
                System.out.println("Clip load fail: " + name);
                return new Clips(null, 0);
            }
            catch (Exception ee) {
                return null;
            }
        }
    }

    public static void touch() {
    }

    public static class Clips {
        public Clip[] clips;
        private int p;
        private int count;

        public Clips(byte[] buffer, int count) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
            if (buffer == null) {
                return;
            }
            this.clips = new Clip[count];
            this.count = count;
            int i = 0;
            while (i < count) {
                this.clips[i] = AudioSystem.getClip();
                this.clips[i].open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(buffer)));
                ++i;
            }
        }

        public void play() {
            if (this.clips == null) {
                System.out.println("Sound doesn't exist.");
                return;
            }
            this.clips[this.p].stop();
            this.clips[this.p].setFramePosition(0);
            this.clips[this.p].start();
            ++this.p;
            if (this.p >= this.count) {
                this.p = 0;
            }
        }
    }
}

