/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.gui;

import java.awt.event.MouseEvent;
import org.crusty.engine.GUI.Button;
import org.crusty.engine.GUI.MouseOverPane;
import org.crusty.engine.RootEntity;
import org.crusty.engine.Screen;
import org.crusty.g2103.Sound;
import org.crusty.g2103.enemies.Enemy;
import org.crusty.g2103.enemies.spawners.CircleWaveSpawner;
import org.crusty.g2103.enemies.spawners.CrossWaveSpawner;
import org.crusty.g2103.enemies.spawners.SquareWaveSpawner;
import org.crusty.g2103.levels.LevelMaze;

public class NextWaveButton
extends Button {
    public NextWaveButton(Screen s, int x, int y, int width, int height, MouseOverPane mouseOverPane) {
        super(s, x, y, width, height, mouseOverPane);
    }

    @Override
    public void mousePressed(MouseEvent e1) {
        if (this.mouseOver && this.screen instanceof LevelMaze) {
            boolean enemiesOnScreen = false;
            for (RootEntity e : this.screen.getEntities()) {
                if (!(e instanceof Enemy)) continue;
                enemiesOnScreen = true;
                break;
            }
            if (!enemiesOnScreen) {
                int waveNum = ((LevelMaze)this.screen).getWaveNum();
                if (waveNum % 7 == 0) {
                    int newHp = (int)(100.0 + Math.floor(((LevelMaze)this.screen).getEnemyWaveNum()) * 3.0);
                    newHp = (int)((float)newHp * 1.5f);
                    CircleWaveSpawner ws = new CircleWaveSpawner(this.screen, ((LevelMaze)this.screen).getStart(), ((LevelMaze)this.screen).getEnemyWaveNum(), 1.5, newHp);
                    this.screen.addEntity(ws);
                } else if (waveNum % 3 == 0) {
                    int newHp = (int)(100.0 + Math.floor(((LevelMaze)this.screen).getEnemyWaveNum()) * 3.0);
                    newHp = (int)((double)newHp * 0.5);
                    CrossWaveSpawner ws = new CrossWaveSpawner(this.screen, ((LevelMaze)this.screen).getStart(), ((LevelMaze)this.screen).getEnemyWaveNum(), 6.0, newHp);
                    this.screen.addEntity(ws);
                } else {
                    int newHp = (int)(100.0 + Math.floor(((LevelMaze)this.screen).getEnemyWaveNum()) * 3.0);
                    SquareWaveSpawner ws = new SquareWaveSpawner(this.screen, ((LevelMaze)this.screen).getStart(), ((LevelMaze)this.screen).getEnemyWaveNum(), 3.0, newHp);
                    this.screen.addEntity(ws);
                }
                Sound.t3.play();
            } else {
                Sound.t2.play();
            }
        }
    }
}

