/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.crusty.engine.GUI.Button;
import org.crusty.engine.GUI.MouseOverPane;
import org.crusty.engine.Screen;
import org.crusty.g2103.levels.LevelMaze;

public class TowerButton
extends Button {
    String towerType;
    int cost;

    public TowerButton(Screen s, int x, int y, int width, int height, String towerType, int cost, MouseOverPane mouseOverPane) {
        super(s, x, y, width, height, mouseOverPane);
        this.towerType = towerType;
        this.cost = cost;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.getRect().contains(e.getX(), e.getY()) && this.screen instanceof LevelMaze) {
            ((LevelMaze)this.screen).pickUpTower(this, e);
        }
    }

    public int getCost() {
        return this.cost;
    }

    public String getTowerType() {
        return this.towerType;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        int ox = 30;
        int oy = 30;
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.towerType.equals("LaserTower")) {
            g.setColor(Color.WHITE);
            g.drawOval(this.getRect().x - 15 + ox, this.getRect().y - 15 + oy, 30, 30);
            g.drawOval(this.getRect().x - 18 + ox, this.getRect().y - 18 + oy, 36, 36);
        } else if (this.towerType.equals("FireTower")) {
            g.setColor(Color.WHITE);
            g.drawLine(this.getRect().x - 15 + ox, this.getRect().y - 15 + oy, this.getRect().x + 15 + ox, this.getRect().y + 15 + oy);
            g.drawLine(this.getRect().x + 15 + ox, this.getRect().y - 15 + oy, this.getRect().x - 15 + ox, this.getRect().y + 15 + oy);
        } else if (this.towerType.equals("SlugTower")) {
            g.setColor(Color.WHITE);
            g.drawRect(this.getRect().x - 15 + ox, this.getRect().y - 15 + oy, 30, 30);
        } else if (this.towerType.equals("CannonTower")) {
            g.setColor(Color.WHITE);
            int[] nArray = new int[3];
            nArray[1] = 15;
            nArray[2] = -15;
            int[] xPoints = nArray;
            int[] yPoints = new int[]{-15, 15, 15};
            int i = 0;
            while (i < xPoints.length) {
                int n = i;
                xPoints[n] = xPoints[n] + (this.getRect().x + ox);
                int n2 = i++;
                yPoints[n2] = yPoints[n2] + (this.getRect().y + oy);
            }
            g.drawPolygon(xPoints, yPoints, xPoints.length);
        }
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.drawString("" + this.cost, this.getRect().x + 40, this.getRect().y + 15);
    }

    public void incCost() {
        ++this.cost;
    }

    public void decCost() {
        --this.cost;
    }
}

