/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.levels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.Locale;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.FontStore;
import org.crusty.engine.Screen;
import org.crusty.g2103.Game;
import org.crusty.g2103.levels.LevelHighScores;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.mandelbrot.Mandelbrot;

public class LevelNameInput
extends Screen {
    Image background;
    String name = "";
    String country = Locale.getDefault().getDisplayCountry();
    int score;

    public LevelNameInput(CrustyEngine engine) {
        super(engine);
        this.background = Mandelbrot.renderRandom(800, 600);
        this.reset();
    }

    public void reset() {
        this.score = -1;
    }

    @Override
    public void logic(long dt) {
        if (this.score == -1) {
            LevelMaze levelMaze = (LevelMaze)((Game)this.getEngine()).screenMaze;
            this.score = levelMaze.getScore();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() <= 'Z' && e.getKeyChar() >= 'A' || e.getKeyChar() <= 'z' && e.getKeyChar() >= 'a' || e.getKeyChar() <= '9' && e.getKeyChar() >= '0') {
            if (this.name.length() < 12) {
                this.name = String.valueOf(this.name) + e.getKeyChar();
            }
        } else if (e.getKeyChar() == '\b') {
            if (this.name.length() > 0) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
        } else if (e.getKeyChar() == '\n' && this.name.length() >= 3) {
            LevelHighScores highScoreScreen = (LevelHighScores)((Game)this.getEngine()).screenHighScores;
            this.setCurrentScreen(highScoreScreen);
            highScoreScreen.submitHighScore(this.name, "" + this.score, this.country);
            highScoreScreen.refreshHighScores();
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.drawImage(this.background, 0, 0, null);
        g.setFont(FontStore.woahFont);
        g.setColor(Color.WHITE);
        g.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g.drawString("2103", -50, 350);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.setFont(FontStore.massiveFont);
        g.drawString("" + this.score, 200, 260);
        g.setFont(FontStore.mainFont);
        g.drawString(this.country, 260, 340);
        g.drawString("Enter name: " + this.name + "_", 260, 380);
        super.draw(g);
    }
}

