/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.towers;

import java.awt.Color;
import java.awt.Graphics2D;
import org.crusty.engine.Screen;
import org.crusty.g2103.Game;
import org.crusty.g2103.Maze;
import org.crusty.g2103.Slug;
import org.crusty.g2103.enemies.Enemy;
import org.crusty.g2103.gui.TowerButton;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.g2103.towers.Tower;

public class SlugTower
extends Tower {
    private long timeBetweenShots = 100L;
    private long lengthOfFire = 200L;
    private long lastTimeShot = 0L;
    Enemy targettedEnemy = null;
    private boolean justFired = false;

    public SlugTower(Screen screen, Maze maze, int costOfThisTower, TowerButton tb) {
        super(screen, maze, costOfThisTower, tb);
        this.rangeRadius = 120;
        this.stage = 0;
        this.damage = 1;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        g.setColor(Color.WHITE);
        g.drawRect((int)this.pos.x - 4, (int)this.pos.y - 4, 8, 8);
        if (this.justFired) {
            g.setColor(Color.YELLOW);
            g.drawOval((int)this.pos.x - 2, (int)this.pos.y - 2, 4, 4);
        }
    }

    @Override
    public void logic(long dt) {
        if (this.screen instanceof LevelMaze && !this.mouseHold) {
            if (this.justFired && Game.currentTimeMillis() - this.lastTimeShot > this.lengthOfFire) {
                this.justFired = false;
            }
            if (Game.currentTimeMillis() - this.lastTimeShot > this.timeBetweenShots) {
                this.targettedEnemy = ((LevelMaze)this.screen).getClosestEnemy(this.pos, this.rangeRadius);
                if (this.targettedEnemy != null) {
                    this.lastTimeShot = Game.currentTimeMillis();
                    this.justFired = true;
                    Slug s = new Slug(this, this.screen, this.pos, this.targettedEnemy, this.damage, 0.3f);
                    this.screen.addEntity(s);
                    ++this.timesShot;
                }
            }
        }
    }
}

