/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.g2103.towers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.crusty.engine.FontStore;
import org.crusty.engine.RootEntity;
import org.crusty.engine.Screen;
import org.crusty.g2103.Cell;
import org.crusty.g2103.Maze;
import org.crusty.g2103.Sound;
import org.crusty.g2103.gui.TowerButton;
import org.crusty.g2103.levels.LevelMaze;
import org.crusty.math.Vec2int;

public abstract class Tower
extends RootEntity {
    protected boolean mouseHold = false;
    private boolean selected = false;
    int stage = 0;
    int damage;
    int costOfThisTower;
    Maze maze;
    int rangeRadius;
    Screen screen;
    protected int totalDamage = 0;
    protected int timesShot = 0;
    protected int enemiesKilled = 0;
    TowerButton tb;
    Font font = FontStore.tinyFont;

    public Tower(Screen screen, Maze maze, int costOfThisTower, TowerButton tb) {
        this.maze = maze;
        this.screen = screen;
        this.costOfThisTower = costOfThisTower;
        this.tb = tb;
        this.rangeRadius = 50;
    }

    public int getStage() {
        return this.stage;
    }

    public void setMousePos(MouseEvent e) {
        this.pos.x = e.getX();
        this.pos.y = e.getY();
        this.setRect(e.getX() - this.maze.boxWidth / 2, e.getY() - this.maze.boxHeight / 2, 0, 0);
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setMouseHold(boolean b) {
        this.mouseHold = b;
    }

    public boolean isMouseHold() {
        return this.mouseHold;
    }

    @Override
    public void draw(Graphics2D g) {
        double x = this.getRect().getX();
        double y = this.getRect().getY();
        double w = this.getRect().getWidth();
        double h = this.getRect().getHeight();
        if (this.selected || this.mouseHold) {
            g.setColor(Color.RED);
            g.drawOval((int)x + this.maze.boxWidth / 2 - this.rangeRadius, (int)y + this.maze.boxHeight / 2 - this.rangeRadius, this.rangeRadius * 2, this.rangeRadius * 2);
            g.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g.fillOval((int)x + this.maze.boxWidth / 2 - this.rangeRadius, (int)y + this.maze.boxHeight / 2 - this.rangeRadius, this.rangeRadius * 2, this.rangeRadius * 2);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (this.selected) {
            g.setColor(Color.WHITE);
            g.drawRect((int)x - 3, (int)y - 3, (int)w + 6, (int)h + 6);
            int ox = 590;
            int oy = 320;
            g.setColor(Color.YELLOW);
            g.drawRect(ox, oy, 140, 170);
            g.setColor(Color.WHITE);
            g.setFont(this.font);
            g.drawString("Damage: " + this.totalDamage, ox + 15, oy + 20);
            g.drawString("Shot:   " + this.timesShot, ox + 15, oy + 40);
            g.drawString("Killed: " + this.enemiesKilled, ox + 15, oy + 60);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mouseHold && this.getRect().contains(e.getX(), e.getY())) {
            boolean toState;
            boolean bl = toState = !this.selected;
            if (this.screen instanceof LevelMaze) {
                ((LevelMaze)this.screen).unselectEverything();
            }
            this.selected = toState;
            Sound.t4.play();
        }
        if (this.mouseHold) {
            if (e.getButton() == 1) {
                Vec2int mazeCoords = this.maze.posToGridCoords(new Vec2int(e.getX(), e.getY()));
                this.maze.getCells()[mazeCoords.x][mazeCoords.y].placeTower(this);
                Sound.t4.play();
            } else {
                if (this.screen instanceof LevelMaze) {
                    ((LevelMaze)this.screen).removeTower(this, this.costOfThisTower);
                    this.tb.decCost();
                }
                Sound.t3.play();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mouseHold) {
            this.pos.x = e.getX();
            this.pos.y = e.getY();
            this.setRect(e.getX() - this.maze.boxWidth / 2, e.getY() - this.maze.boxHeight / 2, this.maze.boxWidth, this.maze.boxHeight);
        }
    }

    public void setCellPos(Cell cell) {
        this.mouseHold = false;
        Vec2int newPos = this.maze.gridCoordsToPos(cell.pos);
        this.pos.x = newPos.x;
        this.pos.y = newPos.y;
        this.setRect(newPos.x - this.maze.boxWidth / 2, newPos.y - this.maze.boxHeight / 2, this.maze.boxWidth, this.maze.boxHeight);
    }

    public void incDamageDone(int damage) {
        this.totalDamage += damage;
    }

    public void incKilled() {
        ++this.enemiesKilled;
    }
}

