/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class Keyboard {
    private static boolean[] keys = new boolean[1024];

    public static void init() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new KeyHandler(), 8L);
    }

    public static void init(Component c) {
        c.addKeyListener(new KeyHandler());
    }

    public static boolean isPressed(int key) {
        return keys[key];
    }

    public static void setPressed(int key, boolean pressed) {
        Keyboard.keys[key] = pressed;
    }

    private static class KeyHandler
    extends KeyAdapter
    implements AWTEventListener {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            keys[e.getKeyCode()] = true;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            KeyEvent nextPress = (KeyEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(401);
            if (nextPress == null || nextPress.getWhen() != e.getWhen()) {
                keys[e.getKeyCode()] = false;
            }
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (e.getID() == 401) {
                this.keyPressed((KeyEvent)e);
            }
            if (e.getID() == 402) {
                this.keyReleased((KeyEvent)e);
            }
        }
    }
}

