/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.util.Random;

public class Spider
extends Enemy {
    private long lastFrameChange;
    private long frameDuration = 250L;
    private int frameNumber;
    private Sprite[] framesRight = new Sprite[4];
    private Sprite[] framesLeft = new Sprite[4];
    double previusY;
    double previusX;
    private boolean lastDir;
    private boolean waiting = false;
    Random r = new Random();
    boolean left = this.r.nextBoolean();
    private int timeTillWaitSwitch = 0;
    private int timeBetPosSwitch = 2000;
    private int lastBite = 0;
    private int timeToBite = 1000;
    Game game;

    public Spider(Game game, int x, int y) {
        super("sprites/spider/s1.png", game, x, y, -1, -1, -1, -1);
        this.game = game;
        this.framesRight[0] = this.sprite;
        this.framesRight[1] = ResourceFactory.get().getSprite("sprites/spider/s2.png");
        this.framesRight[2] = ResourceFactory.get().getSprite("sprites/spider/s3.png");
        this.framesRight[3] = ResourceFactory.get().getSprite("sprites/spider/s4.png");
        this.framesLeft[0] = ResourceFactory.get().getSprite("sprites/spider/s1.png");
        this.framesLeft[1] = ResourceFactory.get().getSprite("sprites/spider/s2.png");
        this.framesLeft[2] = ResourceFactory.get().getSprite("sprites/spider/s3.png");
        this.framesLeft[3] = ResourceFactory.get().getSprite("sprites/spider/s4.png");
        int i = 0;
        while (i < 4) {
            this.framesLeft[i].flip();
            ++i;
        }
    }

    @Override
    public void collidedWith(Entity other) {
        int i;
        Player p;
        if (other instanceof Player && this.lastBite > this.timeToBite) {
            this.lastBite = 0;
            p = (Player)other;
            if (!p.mindControlling) {
                p.hp -= 10;
                i = 0;
                while (i < 5) {
                    this.game.pm.createBloodParticle((int)p.x + 35, (int)p.y + 20, 5);
                    ++i;
                }
            }
        }
        if (other instanceof PlayerMindControlling && this.lastBite > this.timeToBite) {
            this.lastBite = 0;
            p = (Player)this.game.player;
            p.hp -= 10;
            i = 0;
            while (i < 5) {
                this.game.pm.createBloodParticle((int)other.x + 35, (int)other.y + 20, 5);
                ++i;
            }
        }
        if (other instanceof EnemyBouncer) {
            this.left = ((EnemyBouncer)other).left;
        }
        if (other instanceof Block || other instanceof Piston) {
            if (!this.customSize) {
                this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
            } else {
                this.me.setBounds(this.rect.x, this.rect.y, (int)this.rect.getWidth(), (int)this.rect.getHeight());
            }
            if (!other.customSize) {
                this.him.setBounds((int)other.x, (int)other.y, other.sprite.getWidth(), other.sprite.getHeight());
            } else {
                this.him.setBounds(other.rect.x, other.rect.y, (int)other.rect.getWidth(), (int)other.rect.getHeight());
            }
            Rectangle intersection = this.me.intersection(this.him);
            if (intersection.getHeight() > intersection.getWidth()) {
                this.x = intersection.x == this.him.x ? (this.x -= intersection.getWidth()) : (this.x += intersection.getWidth());
            } else {
                this.y = intersection.y == this.him.y ? (this.y -= intersection.getHeight()) : (this.y += intersection.getHeight());
            }
            this.dx *= 0.9;
            this.dy *= 0.9;
        }
    }

    @Override
    public void move(long delta) {
        this.lastFrameChange += delta;
        this.lastBite = (int)((long)this.lastBite + delta);
        this.timeTillWaitSwitch = (int)((long)this.timeTillWaitSwitch + delta);
        if (this.timeTillWaitSwitch > this.timeBetPosSwitch) {
            this.timeTillWaitSwitch = 0;
            if (!this.waiting) {
                if (this.r.nextInt(7) == 1) {
                    this.waiting = true;
                }
            } else if (this.r.nextInt(2) == 1) {
                this.waiting = false;
            }
        }
        if (!this.waiting) {
            this.dx = this.left ? -100.0 : 100.0;
        } else if (Util.distBetween(this.x, this.y, this.game.player.x, this.game.player.y) < 200.0) {
            this.waiting = false;
        }
        if (this.lastFrameChange > this.frameDuration) {
            if (this.dx > 20.0) {
                this.lastFrameChange = 0L;
                ++this.frameNumber;
                if (this.frameNumber >= this.framesRight.length) {
                    this.frameNumber = 0;
                }
                this.sprite = this.framesRight[this.frameNumber];
                this.lastDir = true;
            } else if (this.dx < -20.0) {
                this.lastFrameChange = 0L;
                ++this.frameNumber;
                if (this.frameNumber >= this.framesLeft.length) {
                    this.frameNumber = 0;
                }
                this.sprite = this.framesLeft[this.frameNumber];
                this.lastDir = false;
            } else {
                this.sprite = this.lastDir ? this.framesRight[0] : this.framesLeft[0];
            }
        }
        this.dy += 9.8;
        this.previusY = this.y;
        this.previusX = this.x;
        super.move(delta);
    }
}

