/*
 * Decompiled with CFR 0.152.
 */
package ludumdare.game;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Random;
import ludumdare.game.Sprite;
import org.crusty.math.Vec2double;

public class Particle {
    Vec2double pos;
    Vec2double vel;
    Vec2double acc;
    Sprite sprite;
    Random r = new Random();
    float alpha;
    AlphaComposite ac;

    public Particle(Sprite sprite, Vec2double v, String type, Vec2double dir) {
        this.pos = v;
        this.sprite = sprite;
        this.alpha = 1.0f;
        this.vel = new Vec2double(0.0, 0.0);
        this.acc = new Vec2double(0.0, 0.0);
        if (type.equals("rocketFire")) {
            this.vel = new Vec2double(Math.sin(this.r.nextInt(720)) * (double)0.02f, (Math.sin(this.r.nextInt(720)) + 1.0) * (double)0.02f);
            this.acc = new Vec2double(0.0, 0.0);
        } else if (type.equals("rocketSmoke")) {
            this.vel = new Vec2double(Math.sin(this.r.nextInt(720)) * (double)0.05f, (Math.sin(this.r.nextInt(720)) + 1.0) * (double)0.01f);
            this.acc = new Vec2double(0.0, 0.0);
            this.alpha = 0.5f;
        } else if (type.equals("jettisonSparks")) {
            this.vel = new Vec2double((1.0 - this.r.nextDouble() * 2.0) * 0.05, (1.0 - this.r.nextDouble() * 2.0) * 0.05);
            this.acc = new Vec2double(0.0, 0.0);
            this.alpha = 1.0f;
        } else if (type.equals("capsuleJet")) {
            this.vel = new Vec2double(-dir.x, -dir.y);
            this.acc = new Vec2double(0.0, 0.0);
            this.alpha = 0.2f;
        } else if (type.equals("crash")) {
            this.vel = new Vec2double((1.0 - this.r.nextDouble() * 2.0) * 0.05, (1.0 - this.r.nextDouble() * 2.0) * 0.05);
            this.acc = new Vec2double(0.0, 0.0);
            this.alpha = 0.5f;
        } else if (type.equals("wormhole")) {
            this.vel = new Vec2double((1.0 - this.r.nextDouble() * 2.0) * 0.05, (1.0 - this.r.nextDouble() * 2.0) * 0.05);
            this.acc = new Vec2double(0.0, 0.0);
            this.alpha = 0.5f;
        }
    }

    public void logic(double dt) {
        this.vel.x += this.acc.x / 1000.0;
        this.vel.y += this.acc.y / 1000.0;
        this.pos.x += this.vel.x * dt / 1000000.0;
        this.pos.y += this.vel.y * dt / 1000000.0;
        if (this.alpha > 0.0f) {
            this.alpha = (float)((double)this.alpha - dt / 1.0E9);
        }
        if (this.alpha < 0.0f) {
            this.alpha = 0.0f;
        }
    }

    public void draw(Graphics2D g) {
        this.ac = AlphaComposite.getInstance(3, this.alpha);
        g.setComposite(this.ac);
        g.drawImage((Image)this.sprite.image, (int)this.pos.x, (int)this.pos.y, null);
        this.ac = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(this.ac);
    }
}

