/*
 * Decompiled with CFR 0.152.
 */
package ludumdare.game;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import ludumdare.game.BlackHole;
import ludumdare.game.Entity;
import ludumdare.game.Game;
import ludumdare.game.MessageManager;
import ludumdare.game.ParticleManager;
import ludumdare.game.ScreenManager;
import ludumdare.game.SpaceBody;
import ludumdare.game.Sprite;
import ludumdare.game.SpriteManager;
import ludumdare.game.Star;
import org.crusty.math.Vec2double;
import org.crusty.math.Vec2int;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class Player
extends Entity {
    boolean alive = true;
    Queue<Vec2double> trail = new LinkedList<Vec2double>();
    long lastTimeTrail = 0L;
    long timeCrashed;
    long timeWon = -1L;

    public Player(Sprite sprite) {
        super(sprite);
    }

    @Override
    public void logic(double dt) {
        if (this.timeWon != -1L) {
            if (System.currentTimeMillis() > this.timeCrashed + 3000L) {
                MessageManager.changeAndIncMessage("You win!");
            }
            return;
        }
        if (!this.alive) {
            if (System.currentTimeMillis() > this.timeCrashed + 3000L) {
                ScreenManager.goToScreen(new Vec2int(0, 0));
                this.alive = true;
                this.vel.x = 0.0;
                this.vel.y = 0.0;
                this.acc.x = 0.0;
                this.acc.y = 0.0;
                this.rotation = 0.0;
            }
            return;
        }
        this.acc.x = 0.0;
        this.acc.y = 0.0;
        if (Game.keys[32] || Game.keys[87]) {
            Vec2double up = new Vec2double(0.0, 1.0);
            up = up.rotate(new Vec2double(0.0, 0.0), this.rotation);
            this.acc.x += up.x;
            this.acc.y += up.y;
            Vec2double firePos = new Vec2double(this.pos.x + this.rotatePoint.x - 10.0, this.pos.y + this.rotatePoint.y - 10.0);
            ParticleManager.addParticle(1, SpriteManager.getSprite("jet.png"), firePos, "capsuleJet", this.acc);
        }
        if (Game.keys[65]) {
            this.rotation -= (double)0.01f * dt / 1000000.0;
        }
        if (Game.keys[68]) {
            this.rotation += (double)0.01f * dt / 1000000.0;
        }
        if (System.currentTimeMillis() > this.lastTimeTrail + 300L) {
            this.trail.poll();
            while (this.trail.size() < 100) {
                this.trail.add(this.pos.clone().add(new Vec2double(9.0, 9.0)));
            }
        }
        Object[] ents = Game.entities.toArray();
        int i = 0;
        while (i < ents.length) {
            if (ents[i] instanceof SpaceBody) {
                Vec2double pos = ((SpaceBody)ents[i]).pos.add(new Vec2double(((SpaceBody)ents[i]).diameter / 2.0, ((SpaceBody)ents[i]).diameter / 2.0));
                Vec2double vector = pos.sub(this.pos.add(new Vec2double(9.0, 9.0)));
                Vec2double dir = vector.normalise();
                double length = vector.length();
                this.acc.x += dir.x * 1.0 / length * 60.0;
                this.acc.y += dir.y * 1.0 / length * 60.0;
                Vec2double vec2double = new Vec2double(9.0, 9.0);
                if (pos.sub(this.pos.add(vec2double)).length() < ((SpaceBody)ents[i]).diameter / 2.0) {
                    AudioStream as;
                    FileInputStream in;
                    if ((SpaceBody)ents[i] instanceof BlackHole && ((BlackHole)((SpaceBody)ents[i])).wormhole) {
                        ParticleManager.addParticle(20, SpriteManager.getSprite("wormhole.png"), pos.clone().add(new Vec2double(10.0, 10.0)), "wormhole");
                        this.timeWon = System.currentTimeMillis();
                        try {
                            in = new FileInputStream("wormhole.wav");
                            as = new AudioStream((InputStream)in);
                            AudioPlayer.player.start((InputStream)as);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    this.alive = false;
                    this.timeCrashed = System.currentTimeMillis();
                    if ((SpaceBody)ents[i] instanceof Star) {
                        try {
                            in = new FileInputStream("suncrash.wav");
                            as = new AudioStream((InputStream)in);
                            AudioPlayer.player.start((InputStream)as);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            in = new FileInputStream("crash.wav");
                            as = new AudioStream((InputStream)in);
                            AudioPlayer.player.start((InputStream)as);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ParticleManager.addParticle(10, SpriteManager.getSprite("fire.png"), pos.clone().add(new Vec2double(10.0, 10.0)), "crash");
                    ParticleManager.addParticle(5, SpriteManager.getSprite("smoke.png"), pos.clone().add(new Vec2double(10.0, 10.0)), "crash");
                }
            }
            ++i;
        }
        super.logic(dt);
        if (this.pos.x > 500.0 || this.pos.x < 0.0 || this.pos.y > 500.0 || this.pos.y < 0.0) {
            ScreenManager.notifyBorderCross(this.pos.clone());
        }
    }

    @Override
    public void draw(Graphics2D g) {
        Object[] trailArray = this.trail.toArray();
        int i = 0;
        while (i < trailArray.length - 1) {
            Vec2double v1 = (Vec2double)trailArray[i];
            Vec2double v2 = (Vec2double)trailArray[i + 1];
            g.setColor(new Color(255, 255, 255, 10 + i));
            if (v1.sub(v2).length() < 50.0) {
                g.drawLine((int)v1.x, (int)v1.y, (int)v2.x, (int)v2.y);
            }
            ++i;
        }
        super.draw(g);
    }
}

