/*
 * Decompiled with CFR 0.152.
 */
package ludumdare.game;

import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Random;
import ludumdare.game.BlackHole;
import ludumdare.game.DepthComparator;
import ludumdare.game.Entity;
import ludumdare.game.Game;
import ludumdare.game.MessageManager;
import ludumdare.game.Planet;
import ludumdare.game.Player;
import ludumdare.game.Screen;
import ludumdare.game.SpaceBody;
import ludumdare.game.SpaceStation;
import ludumdare.game.SpriteManager;
import ludumdare.game.Star;
import org.crusty.math.Vec2double;
import org.crusty.math.Vec2int;

public class ScreenManager {
    static HashMap<Vec2int, Screen> screens = new HashMap();
    static Screen rootScreen;
    static Screen currentScreen;
    static Vec2int currentSpaceScreen;
    static Random r;
    static int border;

    static {
        currentScreen = null;
        currentSpaceScreen = new Vec2int(0, 0);
        r = new Random();
        border = 50;
    }

    public ScreenManager() {
        PriorityQueue<Entity> entities = new PriorityQueue<Entity>(10, new DepthComparator());
        rootScreen = new Screen(entities, null);
    }

    public static void setRoot(PriorityQueue<Entity> ents, String[] messages) {
        PriorityQueue<Entity> entities = new PriorityQueue<Entity>(10, new DepthComparator());
        entities.addAll(ents);
        rootScreen = new Screen(entities, messages);
    }

    public static Screen getFirstScreen(Vec2int v, Vec2double playerLoc) {
        Screen s = screens.get(v);
        if (s == null) {
            System.out.println("Generating new Screen!");
            PriorityQueue<Entity> pq = new PriorityQueue<Entity>(10, new DepthComparator());
            pq.add(Game.player);
            pq.add(new SpaceStation(SpriteManager.getSprite("stationalpha.png")));
            String[] messages = new String[]{"(" + v.x + ", " + v.y + ") SpaceSystem: " + r.nextInt(1000)};
            s = new Screen(pq, messages);
            s.setupBackgroundStars();
            screens.put(v, s);
        }
        Game.player.pos.x = playerLoc.x;
        Game.player.pos.y = playerLoc.y;
        return s;
    }

    public static Screen getScreen(Vec2int v, Vec2double playerLoc) {
        Screen s = screens.get(v);
        if (s == null) {
            System.out.println("Generating new Screen!");
            s = ScreenManager.generateScreen(v);
        }
        Game.player.pos.x = playerLoc.x;
        Game.player.pos.y = playerLoc.y;
        return s;
    }

    private static Screen generateScreen(Vec2int v) {
        String s;
        PriorityQueue<Entity> pq = new PriorityQueue<Entity>(10, new DepthComparator());
        pq.add(Game.player);
        int numOfPlanets = r.nextInt(3);
        int i = 0;
        while (i < numOfPlanets) {
            s = "";
            s = r.nextInt(4) == 0 ? "planet1.png" : "planet2.png";
            Planet spaceBody = new Planet(SpriteManager.getSprite(s), new Vec2double(border + r.nextInt(500 - border * 2 - SpriteManager.getSprite((String)s).image.getWidth()), border + r.nextInt(500 - border * 2 - SpriteManager.getSprite((String)s).image.getHeight())), r.nextInt(50) + 20);
            spaceBody.generateRandomData();
            pq.add(spaceBody);
            ++i;
        }
        int rad = r.nextInt(50) + 20;
        if (r.nextBoolean()) {
            rad += r.nextInt(50);
        }
        if (r.nextBoolean()) {
            s = "";
            s = r.nextInt(4) == 0 ? "bluestar.png" : "bigstar.png";
            Star star = new Star(SpriteManager.getSprite(s), new Vec2double(border + r.nextInt(500 - border * 2 - SpriteManager.getSprite((String)s).image.getWidth()), border + r.nextInt(500 - border * 2 - SpriteManager.getSprite((String)s).image.getHeight())), rad);
            star.generateRandomData();
            pq.add(star);
        }
        if (r.nextInt(5) == 0) {
            BlackHole bh = new BlackHole(SpriteManager.getSprite("blackhole.png"), new Vec2double(border + r.nextInt(500 - border * 2 - SpriteManager.getSprite((String)"blackhole.png").image.getWidth()), border + r.nextInt(500 - border * 2 - SpriteManager.getSprite((String)"blackhole.png").image.getHeight())), r.nextInt(50) + 20);
            bh.generateRandomData();
            pq.add(bh);
        }
        Object[] arr = pq.toArray();
        int i2 = 0;
        while (i2 < arr.length) {
            int j = 0;
            while (j < arr.length) {
                if (i2 != j && !(arr[i2] instanceof Player) && !(arr[j] instanceof Player) && ((SpaceBody)arr[i2]).pos.sub(((SpaceBody)arr[j]).pos).length() < ((SpaceBody)arr[i2]).diameter / 2.0 + ((SpaceBody)arr[j]).diameter / 2.0) {
                    pq.remove(arr[i2]);
                    System.out.println("Deleted too close Space Body.");
                }
                ++j;
            }
            ++i2;
        }
        String[] messages = new String[]{"(" + v.x + ", " + v.y + ") SpaceSystem: " + r.nextInt(1000)};
        Screen screen = new Screen(pq, messages);
        screen.setupBackgroundStars();
        screens.put(v, screen);
        return screen;
    }

    public static Screen getRoot() {
        return rootScreen;
    }

    public static void notifyIncrement() {
        if (ScreenManager.currentScreen.pos < ScreenManager.currentScreen.messages.length - 1) {
            ++ScreenManager.currentScreen.pos;
        } else {
            System.out.println("Screen switch");
            currentScreen = ScreenManager.currentScreen.nextScreen;
            Game.notifyUpdate();
        }
        MessageManager.changeAndIncMessage(ScreenManager.currentScreen.messages[ScreenManager.currentScreen.pos]);
    }

    public static void goToScreen(Vec2int s) {
        System.out.println("Screen switch: " + s.toString());
        currentScreen = ScreenManager.getScreen(s, new Vec2double(240.0, 237.0));
        ScreenManager.currentSpaceScreen.x = s.x;
        ScreenManager.currentSpaceScreen.y = s.y;
        MessageManager.changeAndIncMessage(ScreenManager.currentScreen.messages[ScreenManager.currentScreen.pos]);
        Game.notifyUpdate();
    }

    public static void notifyBorderCross(Vec2double pos) {
        System.out.println("Screen switch");
        Vec2int nextScreen = currentSpaceScreen;
        if (pos.x > 500.0) {
            ++nextScreen.x;
            currentScreen = ScreenManager.getScreen(nextScreen, new Vec2double(0.0, pos.y));
        } else if (pos.x < 0.0) {
            --nextScreen.x;
            currentScreen = ScreenManager.getScreen(nextScreen, new Vec2double(500.0, pos.y));
        } else if (pos.y > 500.0) {
            ++nextScreen.y;
            currentScreen = ScreenManager.getScreen(nextScreen, new Vec2double(pos.x, 0.0));
        } else if (pos.y < 0.0) {
            --nextScreen.y;
            currentScreen = ScreenManager.getScreen(nextScreen, new Vec2double(pos.x, 500.0));
        }
        MessageManager.changeAndIncMessage(ScreenManager.currentScreen.messages[ScreenManager.currentScreen.pos]);
        Game.notifyUpdate();
    }
}

