/*
 * Decompiled with CFR 0.152.
 */
package ludumdare.game;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Random;
import ludumdare.game.Entity;
import ludumdare.game.Sprite;
import org.crusty.math.Vec2double;

public class SpaceBody
extends Entity {
    long mass;
    String atmosphere;
    Random r = new Random();
    String name = "";
    double diameter;

    public SpaceBody(Sprite sprite, Vec2double pos, int diameter) {
        super(sprite);
        this.pos.x = pos.x;
        this.pos.y = pos.y;
        this.diameter = diameter;
        this.rotation = this.r.nextInt(360);
        this.rotationalVel = (this.r.nextDouble() - 0.5) / 1000.0;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.drawLine((int)this.pos.x, (int)this.pos.y, (int)this.pos.x + 20, (int)this.pos.y - 40);
        g.drawLine((int)this.pos.x + 20, (int)this.pos.y - 40, (int)this.pos.x + 20 + 5, (int)this.pos.y - 40);
        g.drawOval((int)this.pos.x, (int)this.pos.y, (int)this.diameter, (int)this.diameter);
        AffineTransform save = g.getTransform();
        g.rotate(this.rotation, this.pos.x + this.diameter / 2.0, this.pos.y + this.diameter / 2.0);
        g.drawImage(this.sprite.image, (int)this.pos.x, (int)this.pos.y, (int)this.diameter, (int)this.diameter, null);
        g.setTransform(save);
    }

    public void generateRandomData() {
        String[] syllables = new String[]{"bar", "tar", "har", "jar", "dar", "zar", "bin", "din", "fin", "lin", "dor", "bor", "gor", "zul", "mul", "bel", "zel", "cel", "rel", "del", "zeon", "ico", "loz", "snoz", "bour"};
        int num = this.r.nextInt(2) + 2;
        this.name = "";
        int i = 0;
        while (i < num) {
            this.name = String.valueOf(this.name) + syllables[this.r.nextInt(syllables.length)];
            ++i;
        }
        this.name = String.valueOf(("" + this.name.charAt(0)).toUpperCase()) + this.name.substring(1, this.name.length());
        this.mass = Math.abs(this.r.nextLong());
        String[] atmospheres = new String[]{"Oxygen", "Methane", "Hydrogen", "Arsenic"};
        this.atmosphere = "";
        if (this.r.nextBoolean()) {
            this.atmosphere = String.valueOf(this.atmosphere) + "100% " + atmospheres[this.r.nextInt(atmospheres.length)];
        } else {
            int first = this.r.nextInt(100);
            int second = 100 - first;
            int firstNum = this.r.nextInt(atmospheres.length);
            int secondNum = -1;
            while (secondNum == -1 || secondNum == firstNum) {
                secondNum = this.r.nextInt(atmospheres.length);
            }
            this.atmosphere = String.valueOf(this.atmosphere) + first + "% " + atmospheres[firstNum] + " " + second + "% " + atmospheres[firstNum];
        }
        if (this.r.nextInt(6) == 0) {
            this.atmosphere = "None";
        }
    }
}

