/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.util;

import java.awt.Color;
import org.crusty.math.MathUtil;

public class ColourUtil {
    public static Color opposite(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(255 - r, 255 - g, 255 - b);
    }

    public static Color getGradientColor(Color c1, Color c2, int percentShift) {
        if (percentShift > 100) {
            percentShift = 100;
        }
        if (percentShift < 0) {
            percentShift = 0;
        }
        float shift = (float)percentShift / 100.0f;
        int difR = c2.getRed() - c1.getRed();
        int difG = c2.getGreen() - c1.getGreen();
        int difB = c2.getBlue() - c1.getBlue();
        Color grad = new Color(MathUtil.bounds((int)((float)c1.getRed() + (float)difR * shift), 0, 255), MathUtil.bounds((int)((float)c1.getGreen() + (float)difG * shift), 0, 255), MathUtil.bounds((int)((float)c1.getBlue() + (float)difB * shift), 0, 255));
        return grad;
    }

    public static Color addToColour(Color bc, Color ac) {
        return new Color((int)((float)ac.getAlpha() / 255.0f * (float)ac.getRed() + (1.0f - (float)ac.getAlpha() / 255.0f) * (float)bc.getRed()), (int)((float)ac.getAlpha() / 255.0f * (float)ac.getGreen() + (1.0f - (float)ac.getAlpha() / 255.0f) * (float)bc.getGreen()), (int)((float)ac.getAlpha() / 255.0f * (float)ac.getBlue() + (1.0f - (float)ac.getAlpha() / 255.0f) * (float)bc.getBlue()), Math.min(bc.getAlpha() + ac.getAlpha(), 255));
    }
}

