/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.particle;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Random;
import org.crusty.engine.sprite.Sprite;
import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;

public class Particle {
    Vec2 pos;
    Vec2 vel;
    Vec2 acc;
    Sprite sprite;
    float alpha;
    AlphaComposite ac;
    float alphaDecayRate = 1.0f;
    public Vec2int offset;
    float scale = 1.0f;
    double rotation = 0.0;
    double rotationVel = 0.0;
    Vec2int rotatePoint = new Vec2int(0, 0);

    public Particle(Sprite sprite, Vec2 pos, Vec2 vel, Vec2 acc, Vec2int offset, float scale, double rotationVel) {
        this.pos = new Vec2(pos.x, pos.y);
        this.vel = new Vec2(vel.x, vel.y);
        this.acc = new Vec2(acc.x, acc.y);
        this.rotatePoint.x = offset.x;
        this.rotatePoint.y = offset.y;
        this.scale = scale;
        this.offset = new Vec2int(offset.x, offset.y);
        this.sprite = sprite;
        this.alpha = 1.0f;
        Random r = new Random();
        this.rotation = r.nextDouble() * Math.PI * 2.0;
        this.rotationVel = rotationVel;
    }

    public void logic(double dt) {
        this.vel.x += this.acc.x / 1000.0;
        this.vel.y += this.acc.y / 1000.0;
        this.pos.x += this.vel.x * dt / 1000000.0;
        this.pos.y += this.vel.y * dt / 1000000.0;
        if (this.alpha > 0.0f) {
            this.alpha = (float)((double)this.alpha - dt / 1.0E9 * (double)this.alphaDecayRate);
        }
        if (this.alpha < 0.0f) {
            this.alpha = 0.0f;
        }
        this.rotation += this.rotationVel * dt / 1000000.0;
    }

    public void draw(Graphics2D g) {
        AffineTransform save = g.getTransform();
        g.rotate(this.rotation, this.pos.x - (double)this.offset.x + (double)this.rotatePoint.x, this.pos.y - (double)this.offset.y + (double)this.rotatePoint.y);
        this.ac = AlphaComposite.getInstance(3, this.alpha);
        g.setComposite(this.ac);
        int x1 = 0;
        int y1 = 0;
        int x2 = this.sprite.images[0].getWidth();
        int y2 = this.sprite.images[0].getHeight();
        int scaleBorderx = (int)((float)this.sprite.images[0].getWidth() * (this.scale - 1.0f));
        int scaleBordery = (int)((float)this.sprite.images[0].getHeight() * (this.scale - 1.0f));
        g.drawImage(this.sprite.images[0], (int)(this.pos.x - (double)this.offset.x) - scaleBorderx, (int)(this.pos.y - (double)this.offset.y) - scaleBordery, (int)(this.pos.x - (double)this.offset.x + (double)this.sprite.images[0].getWidth()) + scaleBorderx, (int)(this.pos.y - (double)this.offset.y + (double)this.sprite.images[0].getHeight()) + scaleBordery, x1, y1, x2, y2, null);
        this.ac = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(this.ac);
        g.rotate(-this.rotation, this.pos.x - (double)this.offset.x + (double)this.rotatePoint.x, this.pos.y - (double)this.offset.y + (double)this.rotatePoint.y);
        g.setTransform(save);
    }
}

