/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.particle;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Random;
import org.crusty.engine.particle.Particle;
import org.crusty.engine.sprite.Sprite;
import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;

public class ParticleManager {
    private boolean particleDebug = false;
    ArrayList<Particle> particles = new ArrayList();
    Random r = new Random();

    public void logic(double dt) {
        int i = 0;
        while (i < this.particles.size()) {
            this.particles.get(i).logic(dt);
            if (this.particles.get((int)i).alpha == 0.0f) {
                this.particles.remove(this.particles.get(i));
            }
            ++i;
        }
    }

    public void draw(Graphics2D g) {
        int i = 0;
        while (i < this.particles.size()) {
            this.particles.get(i).draw(g);
            ++i;
        }
        if (this.particleDebug) {
            g.setColor(Color.BLACK);
            g.fillRect(5, 400, 100, 20);
            g.setColor(Color.WHITE);
            g.drawRect(5, 400, 100, 20);
            g.drawString("Particles: " + this.particles.size(), 10, 415);
        }
    }

    public void createBurst(int num, Sprite sprite, Vec2 pos) {
        int i = 0;
        while (i < num) {
            Vec2 vel = new Vec2(this.r.nextDouble() - 0.5, this.r.nextDouble() - 0.5);
            vel = vel.normalise();
            Vec2 acc = new Vec2(-vel.x * 0.3, -vel.y * 0.3);
            vel.x *= 0.02;
            vel.y *= 0.02;
            Particle p = new Particle(sprite, pos, vel, acc, new Vec2int(sprite.getWidth() / 2, sprite.getHeight() / 2), 1.5f, (this.r.nextDouble() - 0.5) / 200.0);
            this.particles.add(p);
            ++i;
        }
    }

    public void createBloodBurst(int num, Sprite sprite, Vec2 pos) {
        int i = 0;
        while (i < num) {
            Vec2 vel = new Vec2(this.r.nextDouble() - 0.5, this.r.nextDouble() - 1.0);
            vel = vel.normalise();
            Vec2 acc = new Vec2(0.0, 5.0);
            vel.x *= 0.2 + this.r.nextDouble() / 10.0;
            vel.y *= 0.2 + this.r.nextDouble() / 10.0;
            Particle p = new Particle(sprite, pos, vel, acc, new Vec2int(sprite.getWidth() / 2, sprite.getHeight() / 2), 1.5f, (this.r.nextDouble() - 0.5) / 100.0);
            this.particles.add(p);
            ++i;
        }
    }
}

