/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.enemies;

import java.awt.Color;
import java.awt.Graphics2D;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.levels.TerrainLevel;

public class Turret
extends Entity {
    Worm worm;
    boolean targetting = false;
    TerrainLevel terrainLevel;
    long startTargettingTime = 0L;
    int timeToKill = 700;
    boolean canKill = false;
    float firingStage = 0.0f;

    public Turret(Sprite[] sprites, int xoffset, int yoffset, Worm worm, TerrainLevel terrainLevel) {
        super(sprites, xoffset, yoffset);
        this.worm = worm;
        this.terrainLevel = terrainLevel;
        this.depth = -20;
    }

    @Override
    public void logic(long dt) {
        if (!this.worm.isDead()) {
            if (this.terrainLevel.isFree((int)this.pos.x, (int)this.pos.y, (int)this.worm.pos.x, (int)this.worm.pos.y)) {
                if (!this.targetting) {
                    this.targetting = true;
                    this.startTargettingTime = CrustyEngine.currentTimeMillis();
                    SoundManager.playSound("sounds/turret.wav");
                }
            } else {
                this.targetting = false;
            }
            if (this.targetting) {
                this.firingStage = (float)(CrustyEngine.currentTimeMillis() - this.startTargettingTime) / (float)this.timeToKill;
                if (CrustyEngine.currentTimeMillis() - this.startTargettingTime > (long)this.timeToKill) {
                    this.worm.kill();
                }
            }
        } else {
            this.targetting = false;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (this.targetting) {
            g.setColor(Color.RED);
            g.drawLine((int)this.pos.x, (int)this.pos.y, (int)this.worm.pos.x, (int)this.worm.pos.y);
            g.setColor(Color.RED);
            float rad = 30.0f - this.firingStage * 30.0f;
            g.drawOval((int)(this.pos.x - (double)rad), (int)(this.pos.y - (double)rad), (int)rad * 2, (int)rad * 2);
        }
    }
}

