/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.levels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.Screen;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.perlin.PerlinNoise;
import org.crusty.wurrums.entities.Gun;
import org.crusty.wurrums.entities.Worm;

public class EditLevel
extends Screen {
    BufferedImage perlinNoise;
    Color colour = new Color(255, 255, 155, 255);

    public EditLevel(CrustyEngine engine) {
        super(engine);
        double wormy;
        double wormx;
        boolean landBelow;
        int blue;
        int green;
        int red;
        Random r = new Random();
        int startX = r.nextInt(100000000);
        int startY = r.nextInt(100000000);
        int width = this.getEngine().getWidth();
        int height = this.getEngine().getHeight();
        double[] perlinNoiseArray = new double[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                perlinNoiseArray[y * width + x] = PerlinNoise.perlinNoise2D(x + startX, y + startY, 0.015, 0.65, 1.0, 1.0);
                ++x;
            }
            ++y;
        }
        this.perlinNoise = PerlinNoise.doubleArrayToWormsImage(perlinNoiseArray, width, height, this.colour);
        Sprite texture = SpriteManager.getSprite("img/backgrounds/back3.png");
        AlphaComposite ac = AlphaComposite.getInstance(5, 1.0f);
        Graphics2D g = (Graphics2D)this.perlinNoise.getGraphics();
        Composite old = g.getComposite();
        g.setComposite(ac);
        int y2 = 0;
        while (y2 <= this.perlinNoise.getHeight()) {
            int x = 0;
            while (x <= this.perlinNoise.getWidth()) {
                g.drawImage((Image)texture.images[0], x, y2, null);
                x += texture.getWidth();
            }
            y2 += texture.getHeight();
        }
        g.setComposite(old);
        SpriteManager.addSprite(this.perlinNoise, "perlinNoise1");
        Entity perlinNoiseEntity = new Entity(new Sprite[]{SpriteManager.getSprite("perlinNoise1")}, 0, 0);
        perlinNoiseEntity.pos.x = 0.0;
        perlinNoiseEntity.pos.y = 0.0;
        block4: do {
            wormx = 100 + r.nextInt(this.perlinNoise.getWidth() - 200);
            wormy = 100 + r.nextInt(this.perlinNoise.getHeight() - 300);
            int c = this.perlinNoise.getRGB((int)wormx, (int)wormy);
            red = (c & 0xFF0000) >> 16;
            green = (c & 0xFF00) >> 8;
            blue = c & 0xFF;
            landBelow = false;
            int i = (int)wormy;
            while (i < this.perlinNoise.getHeight()) {
                int c2 = this.perlinNoise.getRGB((int)wormx, i);
                int red2 = (c2 & 0xFF0000) >> 16;
                int green2 = (c2 & 0xFF00) >> 8;
                int blue2 = c2 & 0xFF;
                if (red2 != 0 || green2 != 0 || blue2 != 0) {
                    landBelow = true;
                    System.out.println("Land at: " + wormx + ", " + i);
                    continue block4;
                }
                ++i;
            }
        } while ((red != 0 || green != 0 || blue != 0) && !landBelow);
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(8, 1.0f));
        g.setColor(Color.BLACK);
        int rad = 30;
        g.fillOval((int)wormx - rad, (int)wormy - rad, rad * 2, rad * 2);
        g.setComposite(oldComp);
        Worm worm = new Worm(null, wormx, wormy, new Sprite[]{SpriteManager.getSprite("WormWalkingLeft"), SpriteManager.getSprite("WormWalkingRight"), SpriteManager.getSprite("WormDeadLeft"), SpriteManager.getSprite("WormDeadRight"), SpriteManager.getSprite("WormFlyingLeft"), SpriteManager.getSprite("WormFlyingRight")}, 10, 18);
        Gun assaultRifle = new Gun(new Sprite[]{SpriteManager.getSprite("img/guns/assaultrifle.bmp")}, 13, 4, null);
        assaultRifle.setWorm(worm);
        worm.setGun(assaultRifle);
        this.addEntity(worm);
        this.addEntity(perlinNoiseEntity);
        this.addEntity(assaultRifle);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, CrustyEngine.width, CrustyEngine.height);
        super.draw(g);
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        if (CrustyEngine.keys[80]) {
            File file = new File("level.png");
            try {
                ImageIO.write((RenderedImage)this.perlinNoise, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (CrustyEngine.keys[75]) {
            Graphics2D g = (Graphics2D)this.perlinNoise.getGraphics();
            g.setColor(this.colour);
            int rad = 20;
            g.fillOval(e.getX() - rad, e.getY() - rad, rad * 2, rad * 2);
            Sprite texture = SpriteManager.getSprite("img/backgrounds/back3.png");
            AlphaComposite ac = AlphaComposite.getInstance(5, 1.0f);
            Composite old = g.getComposite();
            g.setComposite(ac);
            int y = 0;
            while (y <= this.perlinNoise.getHeight()) {
                int x = 0;
                while (x <= this.perlinNoise.getWidth()) {
                    g.drawImage((Image)texture.images[0], x, y, null);
                    x += texture.getWidth();
                }
                y += texture.getHeight();
            }
            g.setComposite(old);
        } else if (CrustyEngine.keys[76]) {
            Graphics2D g = (Graphics2D)this.perlinNoise.getGraphics();
            Composite old = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(8, 1.0f));
            g.setColor(Color.BLACK);
            int rad = 20;
            g.fillOval(e.getX() - rad, e.getY() - rad, rad * 2, rad * 2);
            g.setComposite(old);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
    }
}

