package org.crusty.wurrums.entities;

import java.awt.Color;
import java.awt.Graphics2D;

import org.crusty.wurrums.levels.TerrainLevel;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;

public class Flag extends Entity {

	Worm worm;
	int distanceToWormToTriggerEnd = 20;
	TerrainLevel screen;
	boolean triggered = false;
	long lastTriggered = 0;
	long timeToSwitch = 1500;
	double rad = 12;
	
	public Flag(Sprite[] sprites, int xoffset, int yoffset, Worm worm, TerrainLevel screen) {
		super(sprites, xoffset, yoffset);
		this.worm = worm;
		this.screen = screen;
		depth = 6;
	}
	
	public void draw(Graphics2D g) {
		if (triggered) {
			g.setColor(Color.WHITE);
			g.fillOval((int) (pos.x - rad + 10), (int) (pos.y - rad + 7), (int) rad*2, (int) rad*2);
		}
		super.draw(g);
	}

	public void logic(long dt) {
		if (worm != null) {
			if (worm.pos.sub(this.pos).length() < distanceToWormToTriggerEnd) {
				if (!triggered) {
					SoundManager.playSound("sounds/flag.wav");
					triggered = true;
					lastTriggered = CrustyEngine.currentTimeMillis();
				}
			}
		}
		if (triggered) {
			rad = (Math.sin(CrustyEngine.currentTimeMillis()/100f) + 1)*6;
			if (CrustyEngine.currentTimeMillis() - lastTriggered > timeToSwitch) {
				System.out.println("Trigger screen move.");
				screen.setCurrentScreen(screen.getNextScreen());
			}
		}

	}
	
}
