package org.crusty.wurrums.entities;

import java.util.Random;

import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;

public class Floater extends Entity {

	public boolean markedForDeletion = false;
	
	public Floater(Sprite[] sprites, int xoffset, int yoffset) {
		super(sprites, xoffset, yoffset);
		
		Random r = new Random();
		vel.x = 0.01 + r.nextDouble()/20;
		
		pos.x = -500 - r.nextInt(500);
		pos.y = r.nextInt(600);
		
		depth = -100 - r.nextInt(50);
		scale = (0.5f + r.nextFloat()*4);
		
		this.rotationalVel = (r.nextDouble() - 0.5)/3000;
	}
	
	public void logic(long dt) {
		super.logic(dt);
		
		if (!this.markedForDeletion && pos.x > 800 + 500) {
			this.markedForDeletion = true;
//			System.out.println("Marked for deletion");
		}
	}

}
