package org.crusty.wurrums.game;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;

import org.crusty.wurrums.levels.EditLevel;
import org.crusty.wurrums.levels.Intro;
import org.crusty.wurrums.levels.Level1;
import org.crusty.wurrums.levels.Level2;
import org.crusty.wurrums.levels.Level3;
import org.crusty.wurrums.levels.Level4;
import org.crusty.wurrums.levels.Level5;
import org.crusty.wurrums.levels.Level6;
import org.crusty.wurrums.levels.Level7;
import org.crusty.wurrums.levels.Level8;
import org.crusty.wurrums.levels.Menu;
import org.crusty.wurrums.levels.TerrainLevel;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.Screen;
import org.crusty.engine.sprite.SpriteManager;

import org.crusty.wurrums.levels.About;

import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class Game extends CrustyEngine {
	
	private static final long serialVersionUID = -9001944339068409533L;
	
	public Screen screen1;
	
	public static Screen menu;
	
	public TerrainLevel level1, level2, level3, level4, level5, level6, level7, level8, intro, about;
	
	long songStart;
	
	Color[] colors = {
			Color.WHITE,
			Color.YELLOW,
			Color.BLUE,
			Color.GREEN,
			Color.CYAN,
			Color.MAGENTA,
			Color.ORANGE,
			Color.RED,
			Color.BLACK
	};
	
	Random r = new Random();
	
	public Game(int width, int height, String title) {
		super(width, height, title);
		
		/* Load all screen entities */
		
		screen1 = new EditLevel(this); // Screen for drawing levels
		
		about = new About(this, null);
		level8 = new Level8(this, about);
		level7 = new Level7(this, level8);
		level6 = new Level6(this, level7);
		level5 = new Level5(this, level6);
		level4 = new Level4(this, level5);
		level3 = new Level3(this, level4);
		level2 = new Level2(this, level3);
		level1 = new Level1(this, level2);
		intro = new Intro(this, level1);
		
		menu = new Menu(this, new Screen[] { intro, about });
		
//		this.currentScreen = screen1;
		this.currentScreen = menu;
		
		// Load the tune and play it
		AudioStream song = null;
		InputStream in;
		try {
			URL url = ClassLoader.getSystemResource("sounds/song.mid");
			in = url.openStream(); 
			
			song = new AudioStream(in);
			AudioPlayer.player.start(song);
			songStart = CrustyEngine.currentTimeMillis();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
	
	public static Screen getMenu() {
		return menu;
	}
	
	public void logic(long dt) {
		super.logic(dt);
		if (CrustyEngine.currentTimeMillis() - songStart > 1000 * (60 * 5 + 1)) {
			songStart = CrustyEngine.currentTimeMillis();
			System.out.println("Replaying song.");
			// Load the tune and play it
			AudioStream song = null;
			InputStream in;
			try {
				URL url = ClassLoader.getSystemResource("sounds/song.mid");
				in = url.openStream(); 
				
				song = new AudioStream(in);
				AudioPlayer.player.start(song);
				songStart = CrustyEngine.currentTimeMillis();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	public static void main(String[] args) {
		Game g = new Game(800, 600, "Wurrums - Elliot Walmsley");
		g.gameLoop();
	}
	
	public void loadImages() {
		String[] wormWalking = {
				"img/walking/w1.png",
				"img/walking/w2.png",
				"img/walking/w3.png",
				"img/walking/w4.png",
				"img/walking/w5.png",
				"img/walking/w6.png",
				"img/walking/w7.png",
			};
//		for (String s : wormWalking) {
//			SpriteManager.addSprite(s, 10, 18);
//		}
		SpriteManager.addSprite("WormWalkingLeft", wormWalking);
		SpriteManager.addFlipSprite("WormWalkingRight", wormWalking);
		
		String[] deadSprites = {
			"img/dead/d1.png"
		};
		SpriteManager.addSprite("WormDeadLeft", deadSprites);
		SpriteManager.addFlipSprite("WormDeadRight", deadSprites);
		
		String[] flyingSprites = {
			"img/flying/w1.png",
			"img/flying/w2.png"
		};
		SpriteManager.addSprite("WormFlyingLeft", flyingSprites);
		SpriteManager.addFlipSprite("WormFlyingRight", flyingSprites);
			
		
		String[] gunSprites = {
			"img/guns/assaultrifle.bmp",
			"img/guns/assaultriflenoarm.bmp"
		};
		for (String s : gunSprites)
			SpriteManager.addSprite(s);
		
		String[] particleSprites = {
			"img/particles/dustcloud.bmp",
			"img/particles/blood.bmp",
			"img/particles/bloodsmall.bmp"
		};
		for (String s : particleSprites)
			SpriteManager.addSprite(s);
			
		String[] backgroundSprites = {
				"img/backgrounds/back1.bmp",
				"img/backgrounds/back2.bmp",
				"img/backgrounds/back3.png",
				"img/backgrounds/back4.bmp",
				"img/backgrounds/newterrain.bmp"
			};
		for (String s : backgroundSprites)
			SpriteManager.addSprite(s);
			
//		String[] levelSprites = {
//				"img/levels/level1.png",
//				"img/levels/level2.png"
//			};
//		for (String s : levelSprites)
//			SpriteManager.addSprite(s);
		
		String[] intro = {
			"img/levels/intro.png"
		};
		SpriteManager.addSprite("img/levels/intro.png", intro);
		
		String[] level1 = {
			"img/levels/level1.png"
		};
		SpriteManager.addSprite("img/levels/level1.png", level1);
		
		String[] level2 = {
			"img/levels/level2.png",
			"img/levels/level2solid.png"
		};
		SpriteManager.addSprite("img/levels/level2.png", level2);
		
		String[] level3 = {
			"img/levels/level3.png",
			"img/levels/level3solid.png"
		};
		SpriteManager.addSprite("img/levels/level3.png", level3);
		
		String[] level4 = {
			"img/levels/level4.png"
		};
		SpriteManager.addSprite("img/levels/level4.png", level4);
				
		String[] level5 = {
			"img/levels/level5.png",
		};
		SpriteManager.addSprite("img/levels/level5.png", level5);
		
		String[] level6 = {
			"img/levels/level6.png",
			"img/levels/level6solid.png"
		};
		SpriteManager.addSprite("img/levels/level6.png", level6);
		
		String[] level7 = {
			"img/levels/level7.png",
			"img/levels/level7solid.png"
		};
		SpriteManager.addSprite("img/levels/level7.png", level7);
		
		String[] level8 = {
			"img/levels/level8.png",
			"img/levels/level8solid.png"
		};
		SpriteManager.addSprite("img/levels/level8.png", level8);
			
		
		String[] otherSprites = {
				"img/otherEntities/flag.bmp",
				"img/otherEntities/turret.png",
				"img/otherEntities/bloodsplat.png"
			};
		for (String s : otherSprites)
			SpriteManager.addSprite(s);
				
		
		String[] floaterSprites = {
				"img/floaters/f1.png",
				"img/floaters/f2.png",
				"img/floaters/f3.png"
			};
		for (String s : floaterSprites)
			SpriteManager.addSprite(s);
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		
	}

	@Override
	public void mousePressed(MouseEvent e) {
		this.currentScreen.mousePressed(e);
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		
	}

	@Override
	public void mouseExited(MouseEvent e) {
		
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		
	}

	@Override
	public void mouseMoved(MouseEvent e) {
		if (currentScreen != null)
			this.currentScreen.mouseMoved(e);
	}

	@Override
	public void keyTyped(KeyEvent e) {
		
	}

}
