package org.crusty.wurrums.levels;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.Random;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.FontStore;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.wurrums.entities.Fader;
import org.crusty.wurrums.entities.Floater;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.game.Game;

public class About extends TerrainLevel {

	public About(CrustyEngine engine, TerrainLevel nextScreen) {
		super(engine, nextScreen);
		
		reset();
	}

	@Override
	public Worm getWorm() {
		return null;
	}

	public void draw(Graphics2D g) {
		// Clear
		g.setColor(Color.BLACK);
		g.fillRect(0, 0, CrustyEngine.width, CrustyEngine.height);
		
		super.draw(g);
		
		g.setFont(FontStore.mainFont);
		g.setColor(Color.WHITE);
		g.drawString("Wurrums", 335, 250);
		g.setFont(FontStore.smallFont);
		g.drawString("A LudumDare20 48 hour game by Elliot Walmsley.", 240, 290);
		g.drawString("http://www.crustycode.com/", 300, 310);
		g.drawString("ESC", 770, 20);
		
		
	}
	
	public void logic(long dt) {
		super.logic(dt);
		
		if (Game.keys[KeyEvent.VK_ESCAPE] || Game.keys[KeyEvent.VK_ENTER] || Game.keys[KeyEvent.VK_SPACE]) {
			this.setCurrentScreen(Game.getMenu());
		}
	}
	
	@Override
	public void reset() {
		// Remove all entities
		entities.clear();
		
		Random r = new Random();
		for (int i = 0; i < 5; i++) {
			// Random floaters to start with
			Sprite s = SpriteManager.getSprite("img/floaters/f" + Integer.toString(r.nextInt(3) + 1) + ".png");
			Floater f = new Floater(new Sprite[] { s }, 50, 50);
			f.pos.x = r.nextInt(100 + 800) - 100;
			f.pos.y = r.nextInt(200 + 600) - 200;
			addEntity(f);
//			System.out.println("Floater: " + f.pos);
		}
		
		Fader f = new Fader(Color.BLACK, 0.8f);
		addEntity(f);
	}

}
