package org.crusty.wurrums.levels;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Random;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;

import org.crusty.wurrums.entities.Fader;
import org.crusty.wurrums.entities.Flag;
import org.crusty.wurrums.entities.Floater;
import org.crusty.wurrums.entities.Gun;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.enemies.Turret;

public class Level8 extends TerrainLevel {
	
	Worm worm;
	
	public Level8(CrustyEngine engine, TerrainLevel nextScreen) {
		super(engine, nextScreen);
		
		reset();
	}
	
	@Override
	public Worm getWorm() {
		return worm;
	}

	public void draw(Graphics2D g) {
		// Background
		g.setColor(new Color(20, 20, 175));
		g.fillRect(0, 0, this.background.getWidth(), this.background.getHeight());
		
		super.draw(g);
	}
	
	@Override
	public void reset() {
		// Remove all entities
		entities.clear();
		
		Random r = new Random();
		for (int i = 0; i < 5; i++) {
			// Random floaters to start with
			Sprite s = SpriteManager.getSprite("img/floaters/f" + Integer.toString(r.nextInt(3) + 1) + ".png");
			Floater f = new Floater(new Sprite[] { s }, 50, 50);
			f.pos.x = r.nextInt(100 + 800) - 100;
			f.pos.y = r.nextInt(200 + 600) - 200;
			addEntity(f);
//			System.out.println("Floater: " + f.pos);
		}
		
		SpriteManager.reloadSprite("img/levels/level8.png");
		Sprite s = SpriteManager.getSprite("img/levels/level8.png");
		
		this.background = s.images[0];
		
		if (s.images.length > 1) {
			this.solidbackground = s.images[1];
		}
		
		// Draw over solid background
		Graphics2D g = (Graphics2D) background.getGraphics();
		g.drawImage(solidbackground, 0, 0, null);
		
		Entity backgroundEntity = new Entity(new Sprite[] { s }, 0, 0);
		backgroundEntity.pos.x = 0;
		backgroundEntity.pos.y = 0;
		
		double 	wormx = 60, 
				wormy = 530;
		
		worm = new Worm(this, wormx, wormy, 
				new Sprite[] { 	SpriteManager.getSprite("WormWalkingLeft"),
								SpriteManager.getSprite("WormWalkingRight"),
								SpriteManager.getSprite("WormDeadLeft"),
								SpriteManager.getSprite("WormDeadRight"),
								SpriteManager.getSprite("WormFlyingLeft"),
								SpriteManager.getSprite("WormFlyingRight")
							},
								10, 18);
		
		Gun assaultRifle = new Gun(new Sprite[] { SpriteManager.getSprite("img/guns/assaultrifle.bmp") }, 13, 4, this);
		assaultRifle.setWorm(worm);
		assaultRifle.canRightClick = true;
		worm.setGun(assaultRifle);
		
		Flag flag = new Flag(new Sprite[] { SpriteManager.getSprite("img/otherEntities/flag.bmp") }, 0, 0, worm, this);
		flag.pos.x = 602;
		flag.pos.y = 262;
		
		Sprite[] sprites = { SpriteManager.getSprite("img/otherEntities/turret.png") };
		Turret t = new Turret(sprites, 20, 20, worm, this);
		t.pos.x = 24;
		t.pos.y = 453;
		
		Turret t2 = new Turret(sprites, 20, 20, worm, this);
		t2.pos.x = 84;
		t2.pos.y = 333;
		
		Turret t3 = new Turret(sprites, 20, 20, worm, this);
		t3.pos.x = 30;
		t3.pos.y = 133;
		
		
		
		addEntity(new Fader(new Color(20, 20, 175), 0.9f));
		addEntity(flag);
		addEntity(worm);
		addEntity(backgroundEntity);
		addEntity(assaultRifle);
		addEntity(t);
		addEntity(t2);
		addEntity(t3);
	}

}
