package org.crusty.wurrums.levels;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.Random;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.FontStore;
import org.crusty.engine.Screen;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;

import org.crusty.wurrums.entities.Fader;
import org.crusty.wurrums.entities.Floater;
import org.crusty.wurrums.entities.Worm;

import org.crusty.wurrums.entities.MenuEntity;

public class Menu extends TerrainLevel {

	int menuPos = 0;
	Screen[] screens;
	
	public Menu(CrustyEngine engine, Screen[] screens) {
		super(engine, null);
		
		this.screens = screens;
		
		reset();
	}
	
	public void reset() {
		// Remove all entities
		entities.clear();
		
		Random r = new Random();
		for (int i = 0; i < 5; i++) {
			// Random floaters to start with
			Sprite s = SpriteManager.getSprite("img/floaters/f" + Integer.toString(r.nextInt(3) + 1) + ".png");
			Floater f = new Floater(new Sprite[] { s }, 50, 50);
			f.pos.x = r.nextInt(100 + 800) - 100;
			f.pos.y = r.nextInt(200 + 600) - 200;
			addEntity(f);
//			System.out.println("Floater: " + f.pos);
		}
		
		Fader f = new Fader(Color.BLACK, 0.8f);
		MenuEntity me = new MenuEntity(screens);
		
		addEntity(f);
		addEntity(me);
	}

	public void draw(Graphics2D g) {
		// Clear
		g.setColor(Color.BLACK);
		g.fillRect(0, 0, CrustyEngine.width, CrustyEngine.height);
		
		super.draw(g);
		
		g.setFont(FontStore.mainFont);
		g.setColor(Color.WHITE);
		g.drawString("Wurrums", 335, 250);
		
	}
	
	public void logic(long dt) {
		super.logic(dt);
	}

	@Override
	public void keyTyped(KeyEvent e) {
		
	}

	@Override
	public Worm getWorm() {
		return null;
	}
	
}
