/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.GUI;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.FontStore;
import org.crusty.engine.GUI.GraphicInterfaceObject;
import org.crusty.engine.Screen;

public class MouseOverPane
extends GraphicInterfaceObject {
    Color normalColor = Color.YELLOW;
    Color textColor = Color.WHITE;
    Color mouseOverColor = Color.WHITE;
    Color bgColor = Color.BLACK;
    String[] text = null;
    protected Screen screen;
    Font font = FontStore.smallFont;
    int verticalSpacing = 20;

    public MouseOverPane(Screen s, String[] text) {
        super(0, 0, 0, 0);
        this.screen = s;
        this.text = text;
        this.depth = 999;
        Graphics g = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage bi = gc.createCompatibleImage(1, 1);
        g = bi.getGraphics();
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        int maxWidth = 0;
        int i = 0;
        while (i < text.length) {
            if (fm.stringWidth(text[i]) > maxWidth) {
                maxWidth = fm.stringWidth(text[i]);
            }
            ++i;
        }
        this.getRect().width = maxWidth + 15;
        this.getRect().height = this.verticalSpacing * text.length + 3;
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
    }

    public void setTextColor(Color c) {
        this.textColor = c;
    }

    public void setText(String[] str) {
        this.text = str;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(this.bgColor);
        g.fillRect(this.getRect().x, this.getRect().y, this.getRect().width, this.getRect().height);
        g.setColor(this.normalColor);
        if (this.mouseOver) {
            g.setColor(this.mouseOverColor);
        }
        g.drawRect(this.getRect().x, this.getRect().y, this.getRect().width, this.getRect().height);
        g.setFont(this.font);
        g.setColor(this.textColor);
        int i = 0;
        while (i < this.text.length) {
            g.drawString(this.text[i], this.getRect().x + 10, this.getRect().y + 15 + i * this.verticalSpacing);
            ++i;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.getRect().x = e.getX() + this.getRect().width < CrustyEngine.width ? e.getX() : e.getX() - this.getRect().width;
        this.getRect().y = e.getY() + this.getRect().height < CrustyEngine.height ? e.getY() : e.getY() - this.getRect().height;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

