/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.entity;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.entity.RootEntity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;

public class Entity
extends RootEntity {
    protected Vec2 rotatePoint;
    protected Sprite[] sprites;
    protected Sprite currentSprite;
    protected double rotation = 0.0;
    protected double rotationalVel = 0.0;
    protected float scale = 1.0f;
    protected BufferedImage currentImage;
    public Vec2int offset = new Vec2int(0, 0);
    protected boolean animating = false;
    public boolean drawFlippedHori = false;
    public boolean drawFlippedVert = false;
    protected int curImage = 0;
    protected int timeBetweenFrames = 1000;
    protected long lastTime = CrustyEngine.currentTimeMillis();

    public Entity(Sprite[] sprites, int xoffset, int yoffset) {
        this.sprites = sprites;
        this.currentSprite = this.sprites[0];
        this.rotatePoint = new Vec2(sprites[0].getWidth() / 2, sprites[0].getHeight() / 2);
        this.currentImage = this.sprites[0].images[0];
        this.offset.x = xoffset;
        this.offset.y = yoffset;
    }

    public void setCurImage(int i) {
        this.curImage = i;
        if (this.curImage >= this.currentSprite.images.length) {
            this.curImage = 0;
        }
        this.currentImage = this.currentSprite.images[this.curImage];
    }

    public void setAnimating(boolean b) {
        this.animating = b;
    }

    public void setOffset(Vec2int offset) {
        this.offset.x = offset.x;
        this.offset.y = offset.y;
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        if (this.animating && CrustyEngine.currentTimeMillis() - this.lastTime > (long)this.timeBetweenFrames) {
            this.lastTime = CrustyEngine.currentTimeMillis();
            ++this.curImage;
            if (this.curImage >= this.currentSprite.images.length) {
                this.curImage = 0;
            }
            this.currentImage = this.currentSprite.images[this.curImage];
        }
        this.rotation += this.rotationalVel * (double)dt / 1000000.0;
    }

    @Override
    public void draw(Graphics2D g) {
        int temp;
        AffineTransform save = g.getTransform();
        g.rotate(this.rotation, this.pos.x - (double)this.offset.x + this.rotatePoint.x, this.pos.y - (double)this.offset.y + this.rotatePoint.y);
        g.setComposite(AlphaComposite.getInstance(3, this.alpha));
        int x1 = 0;
        int y1 = 0;
        int x2 = this.currentSprite.getWidth();
        int y2 = this.currentSprite.getHeight();
        if (this.drawFlippedHori) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (this.drawFlippedVert) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        int scaleBorderx = (int)((float)this.currentSprite.getWidth() * (this.scale - 1.0f));
        int scaleBordery = (int)((float)this.currentSprite.getHeight() * (this.scale - 1.0f));
        g.drawImage(this.currentImage, (int)(this.pos.x - (double)this.offset.x) - scaleBorderx, (int)(this.pos.y - (double)this.offset.y) - scaleBordery, (int)(this.pos.x - (double)this.offset.x + (double)this.currentSprite.getWidth()) + scaleBorderx, (int)(this.pos.y - (double)this.offset.y + (double)this.currentSprite.getHeight()) + scaleBordery, x1, y1, x2, y2, null);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.rotate(-this.rotation, this.pos.x - (double)this.offset.x + this.rotatePoint.x, this.pos.y - (double)this.offset.y + this.rotatePoint.y);
        g.setTransform(save);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

