/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.mandelbrot;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class Mandelbrot {
    public static double[][] goodShots = new double[][]{{5.0159471376832484E-5, 5.0159471376832484E-5, -1.0178751793448342, -0.28309454002182344, 200.0}, {0.0013726010306413083, 0.0013726010306413083, 0.2862668957266695, 0.011798508332312656, 200.0}, {3.4315025766032707E-4, 3.4315025766032707E-4, 0.284881426561366, 0.011167969733861806, 200.0}, {6.420066132252917E-5, 6.420066132252917E-5, 0.3655279214209799, 0.5926144641149701, 200.0}, {5.015676665822591E-7, 5.015676665822591E-7, 0.36552962675104633, 0.5926171725803696, 200.0}, {1.5673989580695598E-8, 1.5673989580695598E-8, 0.3655295954030671, 0.5926171569063801, 200.0}, {0.009267201298286575, 0.009267201298286575, -1.3513821137473638, 0.06580581321556553, 200.0}, {4.525000633928992E-6, 4.525000633928992E-6, -1.3509775786906906, 0.06586509072387, 200.0}, {5.65625079241124E-7, 5.65625079241124E-7, -1.3509775221281826, 0.06586509072387, 200.0}, {2.0091873562027716E-8, 2.0091873562027716E-8, -1.4647974010165048, -1.6769268880848882E-5, 200.0}, {6.278710488133661E-10, 6.278710488133661E-10, -1.4647973998863368, -1.6770838558470915E-5, 200.0}, {0.021169953158512722, 0.021169953158512722, -0.3779590728196045, -0.6638161284395212, 200.0}};

    public static Image render(int width, int height, double XZ, double YZ, double XA, double YA, int maxIteration) {
        int[] pixels = new int[width * height];
        int i = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int blue;
                int green;
                int red;
                double X0 = (double)(i % width) * XZ / (double)width - XZ / 2.0 + XA;
                double Y0 = ((double)i - X0) / (double)width * YZ / (double)height - YZ / 2.0 + YA;
                double X = 0.0;
                double Y = 0.0;
                int Iteration = 0;
                while (X * X + Y * Y <= 4.0 & Iteration < maxIteration) {
                    double TempX = X * X - Y * Y + X0;
                    Y = 2.0 * X * Y + Y0;
                    X = TempX;
                    ++Iteration;
                }
                if (Iteration == maxIteration) {
                    red = 255;
                    green = 255;
                    blue = 255;
                } else {
                    red = (int)((double)Iteration / (double)maxIteration * 255.0);
                    green = (int)((double)Iteration / (double)maxIteration * 255.0);
                    blue = 0;
                }
                int alpha = 255;
                pixels[i] = alpha << 24 | red << 16 | green << 8 | blue;
                ++i;
                ++x;
            }
            ++y;
        }
        return Mandelbrot.getImageFromArray(pixels, width, height);
    }

    public static Image renderRandom(int width, int height) {
        Random r = new Random();
        int rand = r.nextInt(goodShots.length);
        System.out.println("Background index: " + rand);
        double XZ = goodShots[rand][0];
        double YZ = goodShots[rand][1];
        double XA = goodShots[rand][2];
        double YA = goodShots[rand][3];
        int maxIteration = (int)goodShots[rand][4];
        return Mandelbrot.render(width, height, XZ, YZ, XA, YA, maxIteration);
    }

    public static BufferedImage getImageFromArray(int[] pixels, int width, int height) {
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        BufferedImage bimg = new BufferedImage(width, height, 1);
        bimg.getGraphics().drawImage(img, 0, 0, null);
        return bimg;
    }
}

