/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.levels;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Random;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.wurrums.enemies.Turret;
import org.crusty.wurrums.entities.Fader;
import org.crusty.wurrums.entities.Flag;
import org.crusty.wurrums.entities.Floater;
import org.crusty.wurrums.entities.Gun;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.levels.TerrainLevel;

public class Level8
extends TerrainLevel {
    Worm worm;

    public Level8(CrustyEngine engine, TerrainLevel nextScreen) {
        super(engine, nextScreen);
        this.reset();
    }

    @Override
    public Worm getWorm() {
        return this.worm;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(new Color(20, 20, 175));
        g.fillRect(0, 0, this.background.getWidth(), this.background.getHeight());
        super.draw(g);
    }

    @Override
    public void reset() {
        this.entities.clear();
        Random r = new Random();
        int i = 0;
        while (i < 5) {
            Sprite s = SpriteManager.getSprite("img/floaters/f" + Integer.toString(r.nextInt(3) + 1) + ".png");
            Floater f = new Floater(new Sprite[]{s}, 50, 50);
            f.pos.x = r.nextInt(900) - 100;
            f.pos.y = r.nextInt(800) - 200;
            this.addEntity(f);
            ++i;
        }
        SpriteManager.reloadSprite("img/levels/level8.png");
        Sprite s = SpriteManager.getSprite("img/levels/level8.png");
        this.background = s.images[0];
        if (s.images.length > 1) {
            this.solidbackground = s.images[1];
        }
        Graphics2D g = (Graphics2D)this.background.getGraphics();
        g.drawImage((Image)this.solidbackground, 0, 0, null);
        Entity backgroundEntity = new Entity(new Sprite[]{s}, 0, 0);
        backgroundEntity.pos.x = 0.0;
        backgroundEntity.pos.y = 0.0;
        double wormx = 60.0;
        double wormy = 530.0;
        this.worm = new Worm(this, wormx, wormy, new Sprite[]{SpriteManager.getSprite("WormWalkingLeft"), SpriteManager.getSprite("WormWalkingRight"), SpriteManager.getSprite("WormDeadLeft"), SpriteManager.getSprite("WormDeadRight"), SpriteManager.getSprite("WormFlyingLeft"), SpriteManager.getSprite("WormFlyingRight")}, 10, 18);
        Gun assaultRifle = new Gun(new Sprite[]{SpriteManager.getSprite("img/guns/assaultrifle.bmp")}, 13, 4, this);
        assaultRifle.setWorm(this.worm);
        assaultRifle.canRightClick = true;
        this.worm.setGun(assaultRifle);
        Flag flag = new Flag(new Sprite[]{SpriteManager.getSprite("img/otherEntities/flag.bmp")}, 0, 0, this.worm, this);
        flag.pos.x = 602.0;
        flag.pos.y = 262.0;
        Sprite[] sprites = new Sprite[]{SpriteManager.getSprite("img/otherEntities/turret.png")};
        Turret t = new Turret(sprites, 20, 20, this.worm, this);
        t.pos.x = 24.0;
        t.pos.y = 453.0;
        Turret t2 = new Turret(sprites, 20, 20, this.worm, this);
        t2.pos.x = 84.0;
        t2.pos.y = 333.0;
        Turret t3 = new Turret(sprites, 20, 20, this.worm, this);
        t3.pos.x = 30.0;
        t3.pos.y = 133.0;
        this.addEntity(new Fader(new Color(20, 20, 175), 0.9f));
        this.addEntity(flag);
        this.addEntity(this.worm);
        this.addEntity(backgroundEntity);
        this.addEntity(assaultRifle);
        this.addEntity(t);
        this.addEntity(t2);
        this.addEntity(t3);
    }
}

